CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_movimento_por_ecf_r05') THEN 
		DROP VIEW IF EXISTS v_movimento_por_ecf_r05;
        RAISE NOTICE 'v_movimento_por_ecf_r05 removida.';
    END IF; 

CREATE OR REPLACE VIEW public.v_movimento_por_ecf_r05
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.cd_cx,
    vd.dt_vd,
    vd.cont_cupom_fisc,
    vd.nr_ecf,
    it.cd_it,
    it.cd_prod,
    prod.ds_prod,
    COALESCE(prod_un_med.ds_un, 'UN'::character varying, prod_un_med.ds_un) AS unidade,
    it.qt_it,
    it.vlr_it,
    (it.qt_it * it.vlr_it * (it.tx_desc / 100::numeric))::numeric(12,4) AS vlr_desc_it,
    it.tot_it AS vl_tot_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.st_it,
    COALESCE(( SELECT b.cd_barra
           FROM est_prod_cd_barra b
          WHERE prod.cd_emp = b.cd_emp AND prod.cd_prod = b.cd_prod
         LIMIT 1), prod.cd_prod::character varying) AS cd_barra,
    it.cd_totalizador_parcial,
    ( SELECT pdv_cx.modelo_ecf
           FROM pdv_cx
          WHERE vd.cd_emp = pdv_cx.cd_emp AND vd.cd_filial = pdv_cx.cd_filial AND vd.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
        CASE
            WHEN COALESCE(vd.reg_alterado::boolean, false) OR COALESCE(it.reg_alterado::boolean, false) = true THEN 1
            ELSE 0
        END AS reg_alterado,
    vd.nr_serie_imp
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
     JOIN est_prod prod ON prod.cd_emp = it.cd_emp AND prod.cd_prod = it.cd_prod
     LEFT JOIN est_prod_un_med prod_un_med ON prod.cd_un_vd = prod_un_med.cd_ctr_un;


	ALTER TABLE v_movimento_por_ecf_r05  OWNER TO postgres;
		
		
	RAISE NOTICE 'View v_movimento_por_ecf_r05 recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();